//
//	Class definition for Test Dialog class
//

#ifndef THE_FERNSACE_DIALOG_H
#define THE_FERNSACE_DIALOG_H

#include "../Game/theGameState.h"
#include "../Utils/theStringManager.h"

#include "ldwTiledDialog.h"
#include "ldwImage.h"
#include "ldwGameWindow.h"
#include "../Utils/thePrizeMsgAssembler.h"
class ldwButton;
class ldwTextControl;

#define cScreenWidth 800
#define cScreenHeight 600
#define cWidthOfCanvasTile 64
#define cHeightOfCanvasTile 64
#define cTextOffsetX 36
#define cTextOffsetY 35
#define cCanvasTotalWidth 448
#define cFadeAmount 0.10f
#define cChoiceA 1
#define cChoiceB 2
//#define cABEvtChoices 22//= last choice numericalvalue + 1 and is used in random selectors
#define cPrevLabelX 200
#define cPrevLabelY 300
#define cNextLabelX 300
#define cNextLabelY	300
#define cNumSkins 23
//#define cPNBtnMargin 30
#define cPNBtnMargin 125
//#define cPNBtnVert 150
#define cPNBtnVert 177


typedef struct {
	
	char composedString[9999];
	char composedResultString[9999];
	char buttonAMessage[256];
	char buttonBMessage[256];
	int selectedEvent;
	int targetVillager;
	int choiceSelected;

} ClothierDataType;

class theFernsaceDialog : public ldwTiledDialog
{
public:

	theFernsaceDialog(int peep);
	~theFernsaceDialog();
	
	int  GetResult();

	bool HandleMessage(int messageId,long data);

private:



	bool choiceMade;

	//const int cChoiceAButtonID;
	//const int cChoiceBButtonID;
	const int cOkButtonID;
	const int cPrevButtonID;
	const int cNextButtonID;

	int size;
	int yStart;
	int villagerY;
	int aux1;
	int aux2;
	int eventSelect;
	int choiceSelected;

	ClothierDataType eventData;

	theGameState * gs;
	theStringManager *strMgr;
	ldwGameWindow *gameWindow;
	thePrizeMsgAssembler *przMsg;

protected:

	bool paramaterUsed ;

	bool ComposeDisplay(int polarity);
	void ComposeResult(void);
	int SelectFilteredEvent(void);
	void DrawNoFadeScene();

	void PrepareString(char *destString, char *sourceString);
	void MakeRandomVillagersSick(int chance);

	ldwButton      *prevButton;
	ldwButton	   *nextButton;
	ldwButton	   *OkButton;

	int  mResult;
};

#endif
